CREATE OR REPLACE FUNCTION code.purge_messages(
    i_uid code.uid
) RETURNS bool AS $$
DECLARE
    v_mids           bigint[];
BEGIN
    -- delete from messages
    -- by chunks
    v_mids := ARRAY(
        SELECT mid
          FROM mail.messages
         WHERE uid = i_uid
         LIMIT impl.purge_mids_chunk_size());

    -- delete from referenced tables first,
    -- cause explicit DELETE faster
    -- then implicit ON DELETE CASCADE

    DELETE FROM mail.windat_messages
     WHERE uid = i_uid
       AND mid = ANY(v_mids);

    DELETE FROM mail.deleted_box
     WHERE uid = i_uid
       AND mid = ANY(v_mids);

    DELETE FROM mail.message_references
     WHERE uid = i_uid
       AND mid = ANY(v_mids);

    DELETE FROM mail.threads_messages
     WHERE uid = i_uid
       AND mid = ANY(v_mids);

    DELETE FROM mail.synced_messages
     WHERE uid = i_uid
       AND mid = ANY(v_mids);

    DELETE FROM mail.messages
     WHERE uid = i_uid
       AND mid = ANY(v_mids);

    RETURN cardinality(v_mids) < impl.purge_mids_chunk_size();
END;
$$ LANGUAGE plpgsql;
