CREATE OR REPLACE FUNCTION code.purge_old_backup(
    i_uid         code.uid,
    i_backup_id   integer
) RETURNS void AS $$
DECLARE
    v_stids   text[];
BEGIN
    WITH backup_box_purged AS (
      DELETE FROM backup.box
       WHERE uid = i_uid
         AND backup_id = i_backup_id
     RETURNING uid, mid, st_id, attributes
    )
    SELECT array_agg(st_id)
      INTO v_stids
      FROM backup_box_purged bbp
     WHERE NOT EXISTS (SELECT 1 FROM mail.messages mm WHERE mm.uid = bbp.uid AND mm.mid = bbp.mid)
       AND NOT impl.is_shared_message(attributes);

    PERFORM code.add_to_storage_delete_queue(i_uid, v_stids);

    DELETE FROM backup.folders WHERE uid = i_uid AND backup_id = i_backup_id;
    DELETE FROM backup.restores WHERE uid = i_uid AND backup_id = i_backup_id;
    DELETE FROM backup.backups WHERE uid = i_uid AND backup_id = i_backup_id;

END;
$$ LANGUAGE plpgsql;
