CREATE OR REPLACE FUNCTION code.reset_folder_unvisited(
    i_uid code.uid,
    i_fid code.fid,
    i_request_info code.request_info DEFAULT NULL
) RETURNS bigint AS $$
DECLARE
    current_revision bigint = code.acquire_current_revision(i_uid);
BEGIN
    UPDATE mail.folders
       SET unvisited = FALSE
     WHERE uid = i_uid
       AND fid = i_fid
       AND unvisited = TRUE;

    IF found THEN
        PERFORM impl.log_change(
            i_uid          => i_uid,
            i_request_info => i_request_info,
            i_revision     => current_revision,
            i_type         => 'folder-reset-unvisited',
            i_changed      => jsonb_build_array(jsonb_build_object(
                                'fid', i_fid))
        );
        RETURN code.increment_revision(i_uid);
    ELSE
        RETURN code.unchanged_revision();
    END IF;
END;
$$ LANGUAGE plpgsql;
