CREATE OR REPLACE FUNCTION code.reset_fresh(
    i_uid code.uid,
    i_request_info code.request_info DEFAULT NULL
) RETURNS bigint AS $$
DECLARE
    current_revision  bigint := code.acquire_current_revision(i_uid);
BEGIN
    UPDATE mail.counters
       SET fresh_count = 0,
           revision = current_revision
     WHERE uid = i_uid
       AND fresh_count > 0;

    IF found THEN
        PERFORM impl.log_change(
            i_uid,
            i_request_info,
            current_revision,
            'fresh-reset',
            (0, impl.get_useful_count(i_uid))::impl.changelog_counters,
            NULL::jsonb,
            NULL::jsonb
        );

        RETURN code.increment_revision(i_uid);
    ELSE
        RETURN code.unchanged_revision();
    END IF;
END;
$$ LANGUAGE plpgsql;
