CREATE OR REPLACE FUNCTION code.reset_tab_unvisited(
    i_uid code.uid,
    i_tab mail.tab_types,
    i_request_info code.request_info DEFAULT NULL
) RETURNS bigint AS $$
DECLARE
    current_revision bigint = code.acquire_current_revision(i_uid);
BEGIN
    UPDATE mail.tabs
       SET unvisited = FALSE
     WHERE uid = i_uid
       AND tab = i_tab
       AND unvisited = TRUE;

    IF found THEN
        PERFORM impl.log_change(
            i_uid          => i_uid,
            i_request_info => i_request_info,
            i_revision     => current_revision,
            i_type         => 'tab-reset-unvisited',
            i_changed      => jsonb_build_array(jsonb_build_object(
                                'tab', i_tab))
        );
        RETURN code.increment_revision(i_uid);
    ELSE
        RETURN code.unchanged_revision();
    END IF;
END;
$$ LANGUAGE plpgsql;
