CREATE OR REPLACE FUNCTION code.store_deleted_message(
    i_uid          code.uid,
    i_coords       code.store_deleted_coordinates,
    i_headers      code.store_headers,
    i_recipients   code.store_recipient[],
    i_attaches     code.store_attach[],
    i_mime         code.store_mime_part[],
    i_request_info code.request_info DEFAULT NULL
) RETURNS SETOF code.store_deleted_result AS $$
DECLARE
    v_store_res impl.store_deleted_result;
BEGIN
    v_store_res := impl.store_deleted_message(
        i_uid        := i_uid::bigint,
        i_coords     := i_coords::impl.store_deleted_coordinates,
        i_headers    := i_headers::impl.store_headers,
        i_recipients := i_recipients::mail.recipient[],
        i_attaches   := i_attaches::mail.attach[],
        i_mime       := i_mime::mail.mime_part[]
    );

    PERFORM impl.log_change(
        i_uid          => i_uid,
        i_request_info => i_request_info,
        i_revision     => v_store_res.revision,
        i_type         => 'store-deleted',
        i_changed      => json_agg(json_build_object('mid', v_store_res.mid))::jsonb
    );

    RETURN NEXT v_store_res::code.store_deleted_result;
END;
$$ LANGUAGE plpgsql;
