CREATE OR REPLACE FUNCTION code.store_message_with_tab(
    i_uid        code.uid,
    i_coords     code.store_coordinates_with_tab,
    i_headers    code.store_headers,
    i_recipients code.store_recipient[],
    i_attaches   code.store_attach[],
    i_lids       code.unique_lids,
    i_threads    code.store_threading,
    i_request_info code.request_info DEFAULT NULL,
    i_mime       code.store_mime_part[] DEFAULT NULL,
    i_mailish_coordinates code.mailish_coordinates DEFAULT NULL,
    i_quiet      boolean DEFAULT NULL
) RETURNS SETOF code.store_result AS $$
DECLARE
    v_store_res impl.store_result;
BEGIN
    v_store_res := impl.store_message(
        i_uid        := i_uid::bigint,
        i_coords     := i_coords::impl.store_coordinates,
        i_headers    := i_headers::impl.store_headers,
        i_recipients := i_recipients::mail.recipient[],
        i_attaches   := i_attaches::mail.attach[],
        i_mime       := i_mime::mail.mime_part[],
        i_lids       := i_lids,
        i_threads    := i_threads::impl.store_threading
    );

    IF i_mailish_coordinates IS NOT NULL THEN
        UPDATE mailish.messages
           SET mid = v_store_res.mid
         WHERE uid = i_uid
           AND fid = i_coords.fid
           AND imap_id = i_mailish_coordinates.imap_id
           AND mid IS NULL;

        IF NOT found THEN
            INSERT INTO mailish.messages
                (uid, fid, imap_id, imap_time, mid)
            VALUES
                (i_uid, i_coords.fid, i_mailish_coordinates.imap_id, i_mailish_coordinates.imap_time, v_store_res.mid);
        END IF;
    END IF;

    PERFORM impl.log_change(
        i_uid          => i_uid,
        i_request_info => i_request_info,
        i_revision     => v_store_res.revision,
        i_type         => 'store',
        i_counters     => (
            v_store_res.fresh_count,
            impl.get_useful_count(i_uid))::impl.changelog_counters,
        i_changed      => v_store_res::impl.changed_with_fids,
        i_quiet        => i_quiet
    );

    RETURN NEXT (
        v_store_res.mid,
        v_store_res.tid,
        v_store_res.imap_id,
        v_store_res.revision)::code.store_result;
END;
$$ LANGUAGE plpgsql;


CREATE OR REPLACE FUNCTION code.store_message(
    i_uid        code.uid,
    i_coords     code.store_coordinates,
    i_headers    code.store_headers,
    i_recipients code.store_recipient[],
    i_attaches   code.store_attach[],
    i_lids       code.unique_lids,
    i_threads    code.store_threading,
    i_request_info code.request_info DEFAULT NULL,
    i_mime       code.store_mime_part[] DEFAULT NULL,
    i_mailish_coordinates code.mailish_coordinates DEFAULT NULL,
    i_quiet      boolean DEFAULT NULL
) RETURNS SETOF code.store_result AS $$
DECLARE
    v_store_res impl.store_result;
BEGIN
    RETURN QUERY
    SELECT *
      FROM code.store_message_with_tab(
        i_uid,
        (
            i_coords.fid,
            i_coords.tid,
            i_coords.seen,
            i_coords.deleted,
            i_coords.st_id,
            i_coords.received_date,
            i_coords.size,
            i_coords.attributes,
            i_coords.pop_uidl,
            NULL
        )::code.store_coordinates_with_tab,
        i_headers, i_recipients, i_attaches,
        i_lids, i_threads, i_request_info,
        i_mime, i_mailish_coordinates, i_quiet
    );
END;
$$ LANGUAGE plpgsql;
