CREATE OR REPLACE FUNCTION code.transit_subscription_state(
    i_uid             code.uid,
    i_subscription_id code.subscription_id,
    i_action          code.subscription_action
) RETURNS mail.shared_folder_subscriptions AS $$
DECLARE
    v_row       mail.shared_folder_subscriptions;
    v_new_state mail.subscription_state;
BEGIN
    v_row := impl.acquire_subscription(i_uid, i_subscription_id);

    SELECT to_state
      INTO v_new_state
      FROM code.subscription_transitions()
     WHERE action = i_action
       AND from_state = (v_row).state;

    IF NOT found THEN
        RAISE EXCEPTION 'There are no known transition from % state with % action', v_row.state, i_action;
    END IF;

    IF v_row.state IS DISTINCT FROM v_new_state THEN
        UPDATE mail.shared_folder_subscriptions
           SET state = v_new_state,
               updated = current_timestamp
         WHERE uid = i_uid
           AND subscription_id = i_subscription_id
        RETURNING * INTO v_row;
    END IF;
    RETURN v_row;
END;
$$ LANGUAGE plpgsql;