CREATE OR REPLACE FUNCTION code.update_folder(
    i_uid       bigint,
    i_fid       integer,
    i_name      text,
    i_parent    integer,
    i_request_info code.request_info DEFAULT NULL
) RETURNS mail.folders AS $$
DECLARE
    current_revision    bigint := code.acquire_current_revision(i_uid);
    folder              mail.folders%ROWTYPE;
BEGIN
    IF EXISTS (
        SELECT 1
          FROM code.default_folders() df, mail.folders f
         WHERE f.fid = i_fid
           AND f.uid = i_uid
           AND f.type = df.type
    ) THEN
        RAISE EXCEPTION 'Can''t update folder % for uid %, it is default', i_fid, i_uid;
    END IF;

    UPDATE mail.folders
       SET name = i_name,
           parent_fid = i_parent,
           revision = current_revision
     WHERE uid = i_uid
       AND fid = i_fid
    RETURNING *
    INTO folder;

    IF NOT found THEN
        RAISE EXCEPTION 'No folder updated uid: %, fid: %' , i_uid, i_fid;
    END IF;

    PERFORM impl.log_change(
        i_uid          => i_uid,
        i_request_info => i_request_info,
        i_revision     => current_revision,
        i_type         => 'folder-modify',
        i_changed      => jsonb_build_array(jsonb_build_object('fid', i_fid))
    );

    PERFORM code.increment_revision(i_uid);

    RETURN folder;
END;
$$ LANGUAGE plpgsql;
