CREATE OR REPLACE FUNCTION code.update_folder_type(
    i_uid       bigint,
    i_fid       integer,
    i_type      mail.folder_types,
    i_request_info code.request_info DEFAULT NULL
) RETURNS bigint AS $$
DECLARE
    current_revision    bigint := code.acquire_current_revision(i_uid);
BEGIN
    IF EXISTS (
        SELECT 1
          FROM code.default_folders() df, mail.folders f
         WHERE f.fid = i_fid
           AND f.uid = i_uid
           AND f.type = df.type
    ) THEN
        RAISE EXCEPTION 'Can''t update type for folder % for uid %, it is default', i_fid, i_uid;
    END IF;

    UPDATE mail.folders
       SET type = i_type,
           revision = current_revision,
           unique_type = i_type != 'user'
     WHERE uid = i_uid
       AND fid = i_fid;

    IF NOT found THEN
        RAISE EXCEPTION 'No folder type updated uid: %, fid: %' , i_uid, i_fid;
    END IF;

    PERFORM impl.log_change(
        i_uid          => i_uid,
        i_request_info => i_request_info,
        i_revision     => current_revision,
        i_type         => 'folder-modify-type',
        i_changed      => jsonb_build_array(jsonb_build_object('fid', i_fid))
    );
    RETURN code.increment_revision(i_uid);

END;
$$ LANGUAGE plpgsql;
