CREATE OR REPLACE FUNCTION code.update_messages(
    i_uid        code.uid,
    i_mids       code.mids,
    set_seen     boolean,
    set_recent   boolean,
    set_deleted  boolean,
    i_lids_add   integer[],
    i_lids_del   integer[],
    i_request_info code.request_info DEFAULT NULL
) RETURNS code.operation_result AS $$
DECLARE
    updated          impl.updated_message[];
    current_revision bigint := code.acquire_current_revision(i_uid);
    lids_add         integer[] := uniq(sort(coalesce(i_lids_add, ARRAY[]::integer[])));
    lids_del         integer[] := uniq(sort(coalesce(i_lids_del, ARRAY[]::integer[])));
BEGIN
    SELECT *
      INTO updated
      FROM impl.update_messages_impl(i_uid, i_mids,
               set_seen, set_recent, set_deleted,
               lids_add, lids_del, current_revision);

    IF updated IS NULL OR cardinality(updated) = 0 THEN
        RETURN code.unchanged_result();
    END IF;

    PERFORM impl.log_change(
        i_uid          => i_uid,
        i_request_info => i_request_info,
        i_revision     => current_revision,
        i_type         => 'update',
        i_changed      => ARRAY(
            SELECT (mid, tid, fid,
                   new_seen, new_recent, new_deleted,
                   new_lids, tab)::impl.short_changed_message
              FROM unnest(updated))::impl.changed_with_fids,
        i_args         => jsonb_build_object(
            'seen',     set_seen,
            'recent',   set_recent,
            'deleted',  set_deleted,
            'lids_add', lids_add,
            'lids_del', lids_del
        )
    );

    PERFORM code.increment_revision(i_uid);

    RETURN (current_revision, ARRAY(SELECT mid FROM unnest(updated)))::code.operation_result;
END;
$$ LANGUAGE plpgsql;
