CREATE OR REPLACE FUNCTION code.update_user_state(
    i_uid             code.uid,
    i_new_state       mail.user_state,
    i_notifies_count  smallint DEFAULT NULL,
    i_request_info    code.request_info DEFAULT NULL
) RETURNS void AS $$
DECLARE
    current_revision  bigint := code.acquire_current_revision(i_uid);
    v_row_user        mail.users;
    v_state           mail.user_state;
BEGIN

    SELECT *
      INTO v_row_user
      FROM mail.users
     WHERE uid = i_uid;

    IF NOT found THEN
        RAISE EXCEPTION 'There is no user with uid %', i_uid;
    END IF;

    IF NOT v_row_user.is_here THEN
        RAISE EXCEPTION 'User with uid %, is not here', i_uid;
    END IF;

    SELECT to_state
      INTO v_state
      FROM code.user_state_transitions()
     WHERE to_state = i_new_state
       AND from_state = v_row_user.state;

    IF NOT found THEN
        RAISE EXCEPTION 'Transition from % state to state % is restricted', v_row_user.state, i_new_state;
    END IF;

    UPDATE mail.users
       SET state = i_new_state,
           last_state_update = current_timestamp,
           notifies_count = COALESCE(i_notifies_count, notifies_count)
     WHERE uid = i_uid;

    PERFORM impl.log_change(
        i_uid,
        i_request_info,
        current_revision,
        'user-state-update',
        NULL::jsonb,
        json_build_object(
            'state', i_new_state,
            'notifies_count', i_notifies_count
        )::jsonb
    );

    PERFORM code.increment_revision(i_uid);
END;
$$ LANGUAGE plpgsql;