CREATE OR REPLACE FUNCTION code.delete_subscriptions_with_unsubscribe_task(
    i_task_id           bigint,
    i_request_info      code.request_info DEFAULT NULL
) RETURNS SETOF mail.shared_folder_subscriptions AS $$
DECLARE
    v_task              mail.unsubscribe_tasks;
    v_subscriptions     mail.shared_folder_subscriptions[];
BEGIN
    SELECT *
    INTO v_task
    FROM mail.unsubscribe_tasks t
    WHERE t.task_id = i_task_id
    FOR UPDATE
    SKIP LOCKED;

    IF NOT found THEN
        RETURN;
    END IF;

    SELECT array_agg(s)
    INTO v_subscriptions
    FROM mail.shared_folder_subscriptions s
    WHERE s.uid = v_task.owner_uid
        AND s.subscriber_uid = v_task.subscriber_uid
        AND s.fid in (select * from unnest(v_task.owner_fids));

    IF cardinality(v_subscriptions) > 0 THEN
        SELECT array_agg(del)
        INTO v_subscriptions
        FROM code.delete_shared_folder_subscriptions(
            v_task.owner_uid,
            ARRAY(SELECT subscription_id FROM unnest(v_subscriptions))::code.subscription_ids,
            i_request_info
        ) del;
    END IF;

    DELETE
    FROM mail.unsubscribe_tasks
    WHERE task_id = i_task_id;

    RETURN QUERY (SELECT * FROM unnest(v_subscriptions));
END;
$$ LANGUAGE plpgsql;
