CREATE OR REPLACE FUNCTION code.initialize_pop3_folder(
    i_uid code.uid,
    i_fid code.fid,
    i_request_info code.request_info DEFAULT NULL
) RETURNS bigint AS $$
DECLARE
    current_revision bigint := code.acquire_current_revision(i_uid);
BEGIN
    UPDATE mail.folders
       SET pop3state.initialized = true,
           revision = current_revision
     WHERE uid = i_uid
       AND fid = i_fid
       AND NOT (pop3state).initialized;

    IF NOT found THEN
        RETURN code.unchanged_revision();
    END IF;

    INSERT INTO mail.pop3_box
        (uid, mid, fid, size)
    SELECT
        i_uid, b.mid, b.fid, m.size
      FROM mail.box b
      JOIN mail.messages m
     USING (uid, mid)
     WHERE b.uid = i_uid
       AND b.fid = i_fid
        ON CONFLICT (uid, mid) DO UPDATE
       SET fid = i_fid;

    PERFORM impl.log_change(
        i_uid,
        i_request_info,
        current_revision,
        'pop3-folder-initialization',
        NULL::jsonb,
        json_build_object('fid', i_fid)::jsonb
    );

    RETURN code.increment_revision(i_uid);
END;
$$ LANGUAGE plpgsql;