CREATE OR REPLACE FUNCTION code.pop3_delete(
    i_uid  code.uid,
    i_mids code.mids,
    i_request_info code.request_info
) RETURNS code.operation_result AS $$
DECLARE
    current_revision bigint := code.acquire_current_revision(i_uid);
    mids_updated bigint[];
BEGIN
    WITH pop_dels AS (
        DELETE
          FROM mail.pop3_box
         WHERE uid = i_uid
           AND mid = ANY(i_mids)
        RETURNING fid, mid
    ), revision_up AS (
        UPDATE mail.folders f
           SET revision = current_revision
         WHERE uid = i_uid
           AND fid IN (SELECT fid FROM pop_dels))
    SELECT array_agg(mid)
      INTO mids_updated
      FROM pop_dels;

    IF coalesce(cardinality(mids_updated), 0) = 0 THEN
        RETURN code.unchanged_result();
    END IF;

    PERFORM impl.log_change(
        i_uid,
        i_request_info,
        current_revision,
        'pop3-delete',
        json_agg(json_build_object('mid', mid))::jsonb,
        json_build_object('i_mids', i_mids)::jsonb
    ) FROM unnest(mids_updated) mid;

    RETURN (code.increment_revision(i_uid),
            mids_updated)::code.operation_result;
END;
$$ LANGUAGE plpgsql;
