CREATE OR REPLACE FUNCTION code.pop3_folders_disable(
    i_uid   code.uid,
    i_fids  integer[],
    i_request_info code.request_info
) RETURNS bigint AS $$
DECLARE
    current_revision bigint := code.acquire_current_revision(i_uid);
BEGIN
    IF (i_fids IS NULL OR #i_fids = 0)
    THEN
        RAISE EXCEPTION 'i_fids are empty';
    END IF;

    UPDATE mail.folders
       SET pop3state.enabled = false,
           revision = current_revision
     WHERE uid = i_uid
       AND fid = ANY(i_fids);

    IF found THEN
        PERFORM impl.log_change(
            i_uid,
            i_request_info,
            current_revision,
            'pop3-folders-disable',
            NULL::jsonb,
            json_build_object('fids', i_fids)::jsonb
        );

        RETURN code.increment_revision(i_uid);
    END IF;
    RETURN code.unchanged_revision();
END;
$$ LANGUAGE plpgsql;
