CREATE OR REPLACE FUNCTION code.confirm_the_job(
    i_worker_id text,
    i_launch_id text
) RETURNS boolean AS $$
BEGIN
    UPDATE mail.doberman_jobs
       SET heartbeated = current_timestamp
     WHERE worker_id = i_worker_id
       AND launch_id = i_launch_id;

    IF found THEN
        RETURN true;
    END IF;

    IF NOT EXISTS (
        SELECT 1
          FROM mail.doberman_jobs
         WHERE worker_id = i_worker_id)
    THEN
        RAISE EXCEPTION 'There are no "%" worker_id in doberman_jobs', i_worker_id;
    END IF;

    RETURN false;
END;
$$ LANGUAGE plpgsql;
