CREATE OR REPLACE FUNCTION code.find_a_job(
    i_timeout        interval,
    i_launch_id      text,
    i_hostname       text,
    i_worker_version text
) RETURNS text AS $$
DECLARE
    v_row mail.doberman_jobs;
BEGIN
    SELECT *
      INTO v_row
      FROM mail.doberman_jobs
     WHERE NOT code.is_system_worker(worker_id)
       AND COALESCE(heartbeated + timeout, '-infinity') < current_timestamp
     ORDER BY heartbeated NULLS FIRST
     FETCH FIRST ROW ONLY
       FOR UPDATE;

    IF NOT found THEN
        RETURN NULL;
    END IF;

    UPDATE mail.doberman_jobs
       SET launch_id = i_launch_id,
           heartbeated = current_timestamp,
           assigned = current_timestamp,
           timeout = i_timeout,
           hostname = i_hostname,
           worker_version = i_worker_version
     WHERE worker_id = (v_row).worker_id;

    INSERT INTO mail.doberman_jobs_change_log
        (worker_id, info)
    VALUES
        ((v_row).worker_id, to_jsonb(v_row));

    RETURN (v_row).worker_id;
END;
$$ LANGUAGE plpgsql;
