CREATE OR REPLACE FUNCTION code.delete_messages(
    i_uid  code.uid,
    i_mids code.mids,
    i_request_info code.request_info DEFAULT NULL
) RETURNS code.operation_result AS $$
DECLARE
    current_revision   constant bigint := code.acquire_current_revision(i_uid);
    hidden_trash_fid   integer;
    hide_mids          bigint[];
    delete_mids        bigint[];
BEGIN
    hidden_trash_fid := code.get_folder_fid(i_uid, 'hidden_trash');

    IF hidden_trash_fid IS NOT NULL AND EXISTS (
       SELECT 1
         FROM settings.settings s
        WHERE s.uid = i_uid
          AND ((
                value->'single_settings'->'mail_b2c_can_use_hidden_trash' = '"on"' AND
                value->'single_settings'->'hidden_trash_enabled' = '"on"'
          ) OR (
                value->'single_settings'->'mail_b2b_admin_search_allowed' = '"on"' AND
                value->'single_settings'->'mail_b2b_admin_search_enabled' = '"on"'
          ))
    ) THEN
        IF NOT EXISTS (
            SELECT 1
              FROM settings.settings s
             WHERE s.uid = i_uid
               AND value->'single_settings'->'mail_b2b_admin_search_allowed' = '"on"'
               AND value->'single_settings'->'mail_b2b_admin_search_enabled' = '"on"'
        ) THEN
            SELECT array_agg(mid)
              INTO delete_mids
              FROM mail.box
             WHERE uid = i_uid
               AND fid = hidden_trash_fid 
               AND mid = ANY(i_mids);
        END IF;
    
        SELECT array_agg(mid)
          INTO hide_mids
          FROM mail.box
         WHERE uid = i_uid
           AND fid != hidden_trash_fid 
           AND mid = ANY(i_mids);

        IF cardinality(delete_mids) > 0 THEN
            PERFORM code.force_delete_messages(
                i_uid,
                delete_mids,
                i_request_info
            );
        END IF;

        IF cardinality(hide_mids) > 0 THEN
            PERFORM code.move_messages(
                i_uid,
                hide_mids,
                hidden_trash_fid,
                NULL,
                i_request_info
            );
        END IF;
       
        IF cardinality(delete_mids) = 0 AND cardinality(hide_mids) = 0 THEN
            RETURN code.unchanged_result();
        END IF;

        RETURN (code.acquire_current_revision(i_uid) - 1, hide_mids || delete_mids);
    ELSE
        return code.force_delete_messages(
            i_uid,
            i_mids,
            i_request_info
        );
    END IF;
END;
$$ LANGUAGE plpgsql;
