CREATE OR REPLACE FUNCTION code.init_user(
    i_uid code.uid
) RETURNS void AS $$
DECLARE
    init_revision     constant bigint := (code.default_serials()).next_revision;
    init_data_version constant integer := constants.newest_data_version();
BEGIN
    INSERT INTO mail.users
        (uid, data_version)
    VALUES
        (i_uid, init_data_version);

    INSERT INTO mail.serials
        (uid,
         next_revision,
         next_fid,
         next_lid,
         next_mid_serial,
         next_owner_subscription_id,
         next_subscriber_subscription_id,
         next_collector_id,
         next_backup_id)
    SELECT
         i_uid,
         init_revision,
         next_fid,
         next_lid,
         next_mid_serial,
         next_owner_subscription_id,
         next_subscriber_subscription_id,
         next_collector_id,
         next_backup_id
      FROM code.default_serials();

    PERFORM code.init_user_data(i_uid, init_revision);

END;
$$ LANGUAGE plpgsql;
