CREATE OR REPLACE FUNCTION code.move_folder_messages(
    i_uid   code.uid,
    src_fid code.fid,
    dst_fid code.fid,
    i_request_info code.request_info DEFAULT NULL
) RETURNS code.operation_result AS $$
DECLARE
    current_revision     constant bigint := code.acquire_current_revision(i_uid);
    mids_to_move         bigint[];
BEGIN
    IF src_fid = dst_fid THEN
        RETURN code.unchanged_result();
    END IF;

    SELECT array_agg(mid)
      INTO mids_to_move
      FROM mail.box
     WHERE uid = i_uid
       AND fid = src_fid;

    IF mids_to_move IS NULL OR cardinality(mids_to_move) = 0 THEN
        RETURN code.unchanged_result();
    ELSE
        RETURN code.move_messages(i_uid, mids_to_move, dst_fid, i_request_info);
    END IF;
END;
$$ LANGUAGE plpgsql;
