CREATE OR REPLACE FUNCTION code.store_welcome_messages(
    i_uid                code.uid,
    i_fid                code.fid,
    i_country            text,
    i_lang               text,
    i_request_info       code.request_info DEFAULT NULL,
    i_tab                mail.tab_types DEFAULT NULL
) RETURNS void AS $$
DECLARE
    c                    record;
    c_curr_date          timestamp with time zone;
    c_lids               integer[];

    c_coords             code.store_coordinates_with_tab;
    c_headers            code.store_headers;
    c_threads            code.store_threading;
BEGIN
    FOR c IN (
        SELECT * FROM code.welcome_mails() wm
        WHERE wm.type = impl.get_welcome_type(i_country, i_lang)
        AND wm.enabled)
    LOOP
        c_curr_date := clock_timestamp();

        c_coords := (
            i_fid,
            NULL,        -- tid
            FALSE,       -- seen
            FALSE,       -- deleted
            c.st_id,
            c_curr_date,
            c.size,
            ARRAY[]::mail.message_attributes[],
            c.pop_uidl,
            i_tab
        )::code.store_coordinates_with_tab;

        c_headers := (
            c.subject,
            c.firstline,
            c_curr_date,
            c.hdr_message_id,
            NULL         -- extra_data
        )::code.store_headers;

        c_threads := (
            'force-new-thread'::mail.threads_merge_rules,
            NULL,        -- references_hashes
            NULL,        -- in_reply_to_hash
            NULL,        -- hash_value
            NULL,        -- hash_namespace
            NULL,        -- hash_uniq_key
            NULL         -- sort_options
        )::code.store_threading;

        c_lids := ARRAY(select lid from code.resolve_labels(i_uid, c.labels, i_request_info));

        PERFORM code.store_message_with_tab(
            i_uid,
            c_coords,
            c_headers,
            c.recipients,
            NULL,         -- attaches
            c_lids,
            c_threads,
            i_request_info,
            c.mime
        );
    END LOOP;

END;
$$ LANGUAGE plpgsql;
