CREATE OR REPLACE FUNCTION code.create_archived_user(
    i_uid code.uid,
    i_revision bigint,
    i_message_count integer
) RETURNS void AS $$
DECLARE
    v_user         mail.users;
    contacts_user_creating_result code.create_contacts_user_result;
BEGIN
    IF NOT pg_try_advisory_xact_lock(i_uid) THEN
        RAISE EXCEPTION 'User % is locked', i_uid;
    END IF;

    SELECT *
      INTO v_user
      FROM mail.users
     WHERE uid = i_uid;

    IF FOUND THEN
        RAISE EXCEPTION 'Current shard is already occupied by user % ', i_uid;
    END IF;

    PERFORM impl.log_change(
        i_uid,
        ('user_archivation', 'user_archivation')::code.request_info,
        i_revision,
        'user-delete',
        NULL::jsonb,
        json_build_object(
            'deleted_date', current_timestamp
        )::jsonb
    );

    INSERT INTO mail.users
        (uid, state)
    VALUES
        (i_uid, 'frozen');

    INSERT INTO mail.serials
        (uid,
         next_revision,
         next_fid,
         next_lid,
         next_mid_serial,
         next_owner_subscription_id,
         next_subscriber_subscription_id,
         next_collector_id,
         next_backup_id)
    SELECT
         i_uid,
         i_revision,
         next_fid,
         next_lid,
         next_mid_serial,
         next_owner_subscription_id,
         next_subscriber_subscription_id,
         next_collector_id,
         next_backup_id
      FROM code.default_serials();

    INSERT INTO mail.archives
        (uid, state, revision, message_count)
    VALUES
        (i_uid, 'archivation_complete', i_revision, i_message_count);

    PERFORM code.init_user_data(i_uid, i_revision);

    contacts_user_creating_result := code.create_contacts_user(i_uid, 'passport_user', 'user_archivation');
    IF contacts_user_creating_result <> 'success' THEN
        RAISE WARNING 'Execution of code.create_contacts_user for uid = % returned ''%''', i_uid, contacts_user_creating_result;
    END IF;

    PERFORM impl.log_change(
        i_uid,
        ('user_archivation', 'user_archivation')::code.request_info,
        i_revision,
        'register',
        (0, 0)::impl.changelog_counters,
        NULL::jsonb,
        json_build_object(
            'country', 'country',
            'lang', 'lang',
            'need_welcomes', false
        )::jsonb
    );

    PERFORM code.update_user_state(i_uid, 'archived');
END;
$$ LANGUAGE plpgsql;
