CREATE OR REPLACE FUNCTION code.get_free_subscriptions(
    i_worker_id             text,
    i_subscriptions_limit   code.subscriptions_limit
) RETURNS SETOF mail.shared_folder_subscriptions AS $$

UPDATE mail.shared_folder_subscriptions
   SET worker_id = i_worker_id,
       updated = current_timestamp
 WHERE (uid, subscription_id) IN (
    SELECT uid, subscription_id
      FROM mail.shared_folder_subscriptions
     WHERE worker_id IS NULL
       AND code.is_operable_subscription(state)
     LIMIT i_subscriptions_limit
       FOR UPDATE
      SKIP LOCKED)
RETURNING *;

$$ LANGUAGE SQL;
