CREATE OR REPLACE FUNCTION code.get_or_create_folder(
    i_uid        code.uid,
    i_name       text,
    i_parent_fid integer, -- don't use domain for parent_fid, cause it can be NULL
    i_type       mail.folder_types,
    i_request_info code.request_info DEFAULT NULL
) RETURNS mail.folders AS $$
DECLARE
    existed mail.folders%ROWTYPE;
BEGIN
    SELECT *
      INTO existed
      FROM mail.folders
    WHERE uid = i_uid
      AND name = i_name
      AND parent_fid IS NOT DISTINCT FROM i_parent_fid;

    IF found THEN
      RETURN existed;
    END IF;

    PERFORM code.acquire_current_revision(i_uid);

    SELECT *
      INTO existed
      FROM mail.folders
    WHERE uid = i_uid
      AND name = i_name
      AND parent_fid IS NOT DISTINCT FROM i_parent_fid;

    IF found THEN
      RETURN existed;
    END IF;

    RETURN code.create_folder(i_uid, i_name, i_parent_fid, i_type, i_request_info);
END;
$$ LANGUAGE plpgsql;