CREATE OR REPLACE FUNCTION code.release_subscription(
    i_uid             code.uid,
    i_subscription_id code.subscription_id,
    i_worker_id       code.worker_id
) RETURNS mail.shared_folder_subscriptions AS $$
DECLARE
    v_row       mail.shared_folder_subscriptions;
BEGIN
    UPDATE mail.shared_folder_subscriptions
       SET worker_id = NULL,
           updated = current_timestamp
     WHERE uid = i_uid
       AND subscription_id = i_subscription_id
       AND worker_id IS NOT DISTINCT FROM i_worker_id
    RETURNING * INTO v_row;

    IF NOT found THEN
        RAISE EXCEPTION 'There are no subscription with uid: %, subscription_id: %, worker_id: %',
                        i_uid,
                        i_subscription_id,
                        i_worker_id;
    END IF;

    RETURN v_row;
END;
$$ LANGUAGE plpgsql;
