CREATE OR REPLACE FUNCTION code.set_folder_archivation_rule(
    i_uid           code.uid,
    i_fid           code.fid,
    i_archive_type  mail.folder_archivation_type,
    i_keep_days     integer,
    i_request_info  code.request_info DEFAULT NULL,
    i_max_size      integer DEFAULT NULL
) RETURNS bigint AS $$
DECLARE
    v_current_revision  bigint := code.acquire_current_revision(i_uid);
BEGIN
    i_max_size = COALESCE(i_max_size, constants.folder_max_size());

    INSERT INTO mail.folder_archivation_rules (
        uid,
        fid,
        revision,
        archive_type,
        keep_days,
        max_size
    )
    VALUES (
        i_uid,
        i_fid,
        v_current_revision,
        i_archive_type,
        i_keep_days,
        i_max_size
    )
    ON CONFLICT (uid, fid)
    DO UPDATE SET
        revision = v_current_revision,
        archive_type = i_archive_type,
        keep_days = i_keep_days,
        created = now(),
        max_size = i_max_size;

    PERFORM impl.log_change(
        i_uid          => i_uid,
        i_request_info => i_request_info,
        i_revision     => v_current_revision,
        i_type         => 'set-archivation-rule',
        i_changed      => jsonb_build_array(jsonb_build_object(
            'fid', i_fid,
            'archive_type', i_archive_type,
            'keep_days', i_keep_days,
            'max_size', i_max_size
        ))
    );

    RETURN code.increment_revision(i_uid);
END;
$$ LANGUAGE plpgsql;
