CREATE OR REPLACE FUNCTION code.delete_job(
    i_worker_id text
) RETURNS void AS $$
BEGIN
    PERFORM (
        SELECT worker_id
          FROM mail.doberman_jobs
         WHERE worker_id = i_worker_id
           FOR UPDATE
    );

    PERFORM code.release_subscription(uid, subscription_id, worker_id) FROM (
        SELECT uid, subscription_id, worker_id
          FROM mail.shared_folder_subscriptions
         WHERE worker_id = i_worker_id) f;

    DELETE
      FROM mail.doberman_jobs
     WHERE worker_id = i_worker_id;

END;
$$ LANGUAGE plpgsql;
