CREATE OR REPLACE FUNCTION code.purge_user(
    i_uid   code.uid,
    i_full  boolean DEFAULT true
) RETURNS void AS $$
DECLARE
    v_purge_steps         regproc[];
    v_purge_proc          regproc;
    v_purge_proc_finished boolean;
BEGIN
    v_purge_steps := CASE i_full
        WHEN true THEN code.purge_user_steps()
        ELSE code.purge_on_delete_user_steps()
    END;
    FOREACH v_purge_proc IN ARRAY v_purge_steps
    LOOP
        LOOP
            RAISE NOTICE 'Running % for uid %', v_purge_proc, i_uid;
            EXECUTE 'SELECT ' || v_purge_proc::text || '($1)'
               INTO v_purge_proc_finished
              USING i_uid;
            EXIT WHEN v_purge_proc_finished;
        END LOOP;
    END LOOP;
END;
$$ LANGUAGE plpgsql;
