CREATE OR REPLACE FUNCTION code.delete_user(
    i_uid          code.uid,
    i_deleted_date timestamp with time zone,
    i_request_info code.request_info DEFAULT NULL
) RETURNS void AS $$
DECLARE
    current_revision bigint := code.acquire_current_revision(i_uid);
    request_id         text;
BEGIN
    request_id = COALESCE(CASE WHEN i_request_info IS NOT NULL THEN i_request_info.x_request_id END,
        'delete_user');
    PERFORM code.delete_contacts_user(
        i_user_id := i_uid,
        i_user_type := 'passport_user',
        i_x_request_id := request_id,
        i_check_user_is_here := true
    );

    UPDATE mail.users
       SET is_deleted = true,
           purge_date = i_deleted_date,
           state = 'deleted',
           last_state_update = current_timestamp
     WHERE uid = i_uid;

    UPDATE mail.archives
       SET state = 'cleaning_in_progress',
           updated = current_timestamp
     WHERE uid = i_uid;

    UPDATE mail.storage_delete_queue
       SET deleted_date = i_deleted_date
     WHERE uid = i_uid
       AND deleted_date > i_deleted_date;

    INSERT INTO mail.deleted_box
        (uid, mid, revision, info, received_date)
    SELECT
        uid, mid, current_revision, json_build_object('received_date', received_date), received_date
      FROM mail.box b
     WHERE uid = i_uid;

    PERFORM code.purge_user(
        i_uid   => i_uid,
        i_full  => false
    );

    PERFORM code.init_contacts_user(
        i_user_id := i_uid,
        i_user_type := 'passport_user',
        i_check_user_is_here := true
    );

    PERFORM code.init_user_data(
        i_uid           => i_uid,
        i_init_revision => current_revision
    );

    PERFORM impl.log_change(
        i_uid,
        i_request_info,
        current_revision,
        'user-delete',
        NULL::jsonb,
        json_build_object(
            'deleted_date', i_deleted_date
        )::jsonb
    );

    PERFORM code.increment_revision(i_uid);
END;
$$ LANGUAGE plpgsql;
