CREATE OR REPLACE FUNCTION code.delete_mailish_entries(
    i_uid           code.uid,
    i_fid           code.fid,
    i_imap_ids      bigint[]
) RETURNS void AS $$
BEGIN
    PERFORM code.acquire_current_revision(i_uid);
    IF EXISTS (
        SELECT 1
          FROM mailish.messages
         WHERE uid = i_uid
           AND fid = i_fid
           AND imap_id = ANY(i_imap_ids)
           AND mid IS NOT NULL
    ) THEN
        RAISE EXCEPTION 'Deleting non empty mid entry from mailish.messages: %, fid: %, uid: %', i_imap_ids, i_fid, i_uid;
    END IF;

    DELETE
      FROM mailish.messages
     WHERE uid = i_uid
       AND fid = i_fid
       AND imap_id = ANY(i_imap_ids);
END;
$$ LANGUAGE plpgsql;
