CREATE OR REPLACE FUNCTION code.delete_mailish_folder_entries(
    i_uid           code.uid,
    i_fids          code.fids
) RETURNS void AS $$
BEGIN
    PERFORM code.acquire_current_revision(i_uid);
    IF EXISTS (
        SELECT 1
        FROM mailish.messages
        WHERE uid = i_uid
          AND fid = ANY(i_fids)
          AND mid IS NOT NULL
      ) THEN
      RAISE EXCEPTION 'Deleting non empty folder from mailish.folders: fids: %, uid: %', i_fids, i_uid;
    END IF;

    DELETE FROM mailish.folders
          WHERE uid = i_uid
            AND fid = ANY(i_fids);
END;
$$ LANGUAGE plpgsql;
