CREATE OR REPLACE FUNCTION code.increment_mailish_entry_errors_count(
    i_uid        code.uid,
    i_fid        code.fid,
    i_foreign_imap_id bigint,
    i_errors_count integer DEFAULT 1
) RETURNS void AS $$
INSERT INTO mailish.messages
    (uid, fid, imap_id, imap_time, errors)
VALUES
    (i_uid, i_fid, i_foreign_imap_id, NULL, i_errors_count)
ON CONFLICT (uid, fid, imap_id)
DO UPDATE SET errors = COALESCE(mailish.messages.errors, 0) + i_errors_count;
$$ LANGUAGE SQL;
