CREATE OR REPLACE FUNCTION code.init_existing_folder_as_mailish(
    i_uid        code.uid,
    i_fid        code.fid,
    i_mailish_folder_info code.mailish_folder_info
) RETURNS void AS $$
BEGIN
    PERFORM code.acquire_current_revision(i_uid);
    IF EXISTS (
        SELECT 1
          FROM mail.folders
         WHERE fid = i_fid
           AND uid = i_uid
           AND message_count != 0
    ) THEN
        RAISE EXCEPTION 'Non empty folder fid: % uid: %', i_fid, i_uid;
    END IF;

    INSERT INTO mailish.folders
        (uid, fid, imap_path, uidvalidity)
    VALUES
        (i_uid, i_fid, i_mailish_folder_info.path, i_mailish_folder_info.uidvalidity);
END;
$$ LANGUAGE plpgsql;
