CREATE OR REPLACE FUNCTION code.move_mailish_messages(
    i_uid        code.uid,
    i_src_fid    code.fid,
    i_dst_fid    code.fid,
    i_ids        code.mailish_move_coords[]
) RETURNS void AS $$
BEGIN
    UPDATE mailish.messages
       SET fid = i_dst_fid,
           imap_id = ids.dst_imap_id
      FROM unnest(i_ids) as ids
     WHERE uid = i_uid
       AND fid = i_src_fid
       AND imap_id = ids.src_imap_id;
END;
$$ LANGUAGE plpgsql;
