CREATE OR REPLACE FUNCTION code.save_mailish_account(
    i_uid        code.uid,
    i_email      text,
    i_imap_login text,
    i_imap_credentials text,
    i_imap_server text,
    i_imap_port  integer,
    i_imap_ssl   boolean,
    i_smtp_login text,
    i_smtp_credentials text,
    i_smtp_server text,
    i_smtp_port  integer,
    i_smtp_ssl   boolean,
    i_token_id   text,
    i_auth_type  mailish.auth_type,
    i_uuid       text,
    i_oauth_app  text,
    i_last_sync  timestamp with time zone
) RETURNS void AS $$
BEGIN
    INSERT INTO mailish.accounts(
        uid,
        email,
        imap_login,
        imap_server,
        imap_port,
        imap_ssl,
        smtp_login,
        smtp_server,
        smtp_port,
        smtp_ssl,
        last_sync
    )
    VALUES(
        i_uid,
        i_email,
        i_imap_login,
        i_imap_server,
        i_imap_port,
        i_imap_ssl,
        i_smtp_login,
        i_smtp_server,
        i_smtp_port,
        i_smtp_ssl,
        i_last_sync
    )
    ON CONFLICT (uid) DO UPDATE SET
       imap_login = i_imap_login,
       imap_server = i_imap_server,
       imap_port = i_imap_port,
       imap_ssl = i_imap_ssl,
       smtp_login = i_smtp_login,
       smtp_server = i_smtp_server,
       smtp_port = i_smtp_port,
       smtp_ssl = i_smtp_ssl;

    INSERT INTO mailish.auth_data(
        uid,
        token_id,
        auth_type,
        oauth_app,
        uuid,
        imap_credentials,
        smtp_credentials
    )
    VALUES(
        i_uid,
        i_token_id,
        i_auth_type,
        i_oauth_app,
        i_uuid,
        i_imap_credentials,
        i_smtp_credentials
    )
    ON CONFLICT (uid, token_id) DO UPDATE SET
        auth_type = i_auth_type,
        oauth_app = i_oauth_app,
        uuid = i_uuid,
        imap_credentials = i_imap_credentials,
        smtp_credentials = i_smtp_credentials;
END;
$$ LANGUAGE plpgsql;
