CREATE OR REPLACE FUNCTION code.delete_collector(
    i_uid          code.uid,
    i_collector_id code.collector_id,
    i_request_info code.request_info DEFAULT NULL
) RETURNS bigint AS $$
DECLARE
    current_revision bigint := code.acquire_current_revision(i_uid);
BEGIN
    DELETE FROM mail.collectors
    WHERE uid = i_uid
      AND collector_id = i_collector_id;

    IF found THEN
        PERFORM impl.log_change(
            i_uid          => i_uid,
            i_request_info => i_request_info,
            i_revision     => current_revision,
            i_type         => 'collector-delete',
            i_changed      => jsonb_build_array(jsonb_build_object('collector_id', i_collector_id))
        );
        RETURN code.increment_revision(i_uid);
    ELSE
        RETURN code.unchanged_revision();
    END IF;
END;
$$ LANGUAGE plpgsql;
