CREATE OR REPLACE FUNCTION code.exchange_archive_state(
    i_uid               code.uid,
    i_user_state        mail.user_state,
    i_from              mail.archive_state,
    i_to                mail.archive_state,
    i_notice            TEXT DEFAULT NULL
) RETURNS TEXT AS $$
DECLARE
    v_row_user        mail.users;
BEGIN
    PERFORM code.acquire_current_revision(i_uid);
    SELECT *
        INTO v_row_user
        FROM mail.users
    WHERE uid = i_uid;

    IF v_row_user.state != i_user_state THEN
        RETURN 'user_wrong_state';
    END IF;
     
    UPDATE mail.archives
       SET state = i_to,
           notice = COALESCE(i_notice, notice),
           updated = current_timestamp
    WHERE uid = i_uid AND state IN (i_from, i_to);

    IF NOT FOUND THEN
        RETURN 'archive_not_found';
    END IF;

    RETURN NULL;

EXCEPTION WHEN SQLSTATE 'MDBA1' THEN
    RETURN 'user_not_here';

END;
$$ LANGUAGE plpgsql;
