CREATE OR REPLACE FUNCTION code.update_collectors_metadata(
  i_uid          code.uid,
  i_collector_id code.collector_id,
  i_data         jsonb,
  i_need_log     boolean,
  i_request_info code.request_info DEFAULT NULL
) RETURNS bigint AS $$
DECLARE
    current_revision bigint := code.acquire_current_revision(i_uid);
BEGIN
    UPDATE mail.collectors
       SET metadata = metadata || i_data
     WHERE uid = i_uid
       AND collector_id = i_collector_id;

    IF i_need_log THEN
        PERFORM impl.log_change(
            i_uid          => i_uid,
            i_request_info => i_request_info,
            i_revision     => current_revision,
            i_type         => 'collector-update',
            i_changed      => jsonb_build_array(jsonb_build_object('collector_id', i_collector_id,
                                                                   'data', i_data))
        );
        RETURN code.increment_revision(i_uid);
    ELSE
        RETURN code.unchanged_revision();
    END IF;
END;
$$ LANGUAGE plpgsql;
