CREATE OR REPLACE FUNCTION code.activate_user_and_update_archive_state(
    i_uid             code.uid,
    i_from            mail.archive_state,
    i_to              mail.archive_state,
    i_request_info    code.request_info DEFAULT NULL
) RETURNS TEXT AS $$
DECLARE
    arch_upd_res TEXT;
BEGIN
    arch_upd_res := code.exchange_archive_state(i_uid, 'archived', i_from, i_to);
    IF arch_upd_res IS NOT NULL THEN
        RETURN arch_upd_res;
    END IF;

    PERFORM code.update_user_state(i_uid, 'active', NULL, i_request_info);
    RETURN NULL;
END;
$$ LANGUAGE plpgsql;
