CREATE OR REPLACE FUNCTION code.create_reply_later_sticker(
    i_uid     code.uid,
    i_mid     code.mid,
    i_fid     code.fid,
    i_date    timestamptz,
    i_tab     mail.tab_types DEFAULT NULL,
    i_request_info code.request_info DEFAULT NULL
) RETURNS mail.stickers_reply_later AS $$
DECLARE
    number_of_stickers integer;
    current_revision bigint := code.acquire_current_revision(i_uid);
    new_sticker mail.stickers_reply_later%ROWTYPE;
BEGIN
    SELECT count(*)
      FROM mail.stickers_reply_later
     WHERE uid = i_uid
      INTO number_of_stickers;

    IF number_of_stickers >= 50 THEN
        RAISE EXCEPTION 'limit of stickers was reached';
    END IF;

    INSERT INTO mail.stickers_reply_later
         (uid, mid, fid, date, tab)
    VALUES (i_uid, i_mid, i_fid, i_date, i_tab)
    RETURNING *
    INTO new_sticker;

    PERFORM impl.log_change(
        i_uid          => i_uid,
        i_request_info => i_request_info,
        i_revision     => current_revision,
        i_type         => 'sticker-create',
        i_changed      => jsonb_build_array(jsonb_build_object(
                            'type', 'reply_later',
                            'mid', new_sticker.mid
                            ))
    );

    PERFORM code.increment_revision(i_uid);

    RETURN new_sticker;
END;
$$ LANGUAGE plpgsql;
