CREATE OR REPLACE FUNCTION code.remove_incorrect_stickers(
    i_uid     code.uid,
    i_request_info code.request_info DEFAULT NULL
) RETURNS bigint[] AS $$
DECLARE
    reply_later_fid  integer;
    started_lid      integer;
    finished_lid     integer;
    incorrect_stickers bigint[];
BEGIN
    SELECT fid
      FROM mail.folders
     WHERE uid = i_uid
       AND type = 'reply_later'
      INTO reply_later_fid;

    SELECT lid
      FROM mail.labels
     WHERE uid = i_uid
       AND type = 'system'
       AND name = 'reply_later_started'
      INTO started_lid;

    SELECT lid
      FROM mail.labels
     WHERE uid = i_uid
       AND type = 'system'
       AND name = 'reply_later_finished'
      INTO finished_lid;

    -- Finished & !Folder | Folder & Started & !Finished
    SELECT array_agg(mb.mid)
      FROM mail.stickers_reply_later AS sr
      JOIN mail.box AS mb
        ON sr.uid = mb.uid AND sr.mid = mb.mid
     WHERE sr.uid = i_uid
       AND NOT (
               (COALESCE(finished_lid, -1) = ANY(mb.lids) AND mb.fid != COALESCE(reply_later_fid, -1))
            OR (COALESCE(finished_lid, -1) != ANY(mb.lids) AND mb.fid = COALESCE(reply_later_fid, -1) AND COALESCE(started_lid, -1) = ANY(mb.lids))
       )
      INTO incorrect_stickers;

    PERFORM code.remove_reply_later_sticker(i_uid, unnest(COALESCE(incorrect_stickers, '{}'::bigint[])), i_request_info);

    RETURN incorrect_stickers;
END;
$$ LANGUAGE plpgsql;
