CREATE OR REPLACE FUNCTION code.remove_reply_later_sticker(
    i_uid     code.uid,
    i_mid     code.mid,
    i_request_info code.request_info DEFAULT NULL
) RETURNS bigint AS $$
DECLARE
    current_revision bigint := code.acquire_current_revision(i_uid);
BEGIN
    DELETE FROM mail.stickers_reply_later
    WHERE uid = i_uid
      AND mid = i_mid;

    IF found THEN
        PERFORM impl.log_change(
            i_uid          => i_uid,
            i_request_info => i_request_info,
            i_revision     => current_revision,
            i_type         => 'sticker-remove',
            i_changed      => jsonb_build_array(jsonb_build_object(
                            'type', 'reply_later',
                            'mid', i_mid
                            ))
        );
        RETURN code.increment_revision(i_uid);
    ELSE
        RETURN code.unchanged_revision();
    END IF;
END;
$$ LANGUAGE plpgsql;
