CREATE OR REPLACE FUNCTION code.create_settings (
    i_uid      bigint,
    i_value    json
) RETURNS integer AS $$
DECLARE
    result integer;
BEGIN
    INSERT INTO settings.settings (
        uid,
        value
    )
    VALUES (
        i_uid,
        i_value::jsonb
    )
    ON CONFLICT DO NOTHING;

    GET DIAGNOSTICS result = ROW_COUNT;
    RETURN result;
END;


$$ LANGUAGE plpgsql;
