CREATE OR REPLACE FUNCTION code.erase_settings (
    i_uid         bigint,
    i_settings    text[]
) RETURNS integer AS $$
DECLARE
    result integer;
BEGIN
    UPDATE settings.settings
       SET value = (
         SELECT impl.settings_difference (
                    value,
                    i_settings
                )
       )
     WHERE uid = i_uid;
    GET DIAGNOSTICS result = ROW_COUNT;
    RETURN result;
END;
$$ LANGUAGE plpgsql;
