CREATE OR REPLACE FUNCTION code.update_settings (
    i_uid         bigint,
    i_settings    json
) RETURNS integer AS $$
DECLARE
    result integer;
BEGIN
    UPDATE settings.settings
       SET value = (
         SELECT impl.merge_settings (
                    value::json,
                    i_settings
                )::jsonb
       )
     WHERE uid = i_uid;
    GET DIAGNOSTICS result = ROW_COUNT;
    RETURN result;
END;
$$ LANGUAGE plpgsql;
