CREATE OR REPLACE FUNCTION code.bulk_modify_settings (
) RETURNS integer AS $$
DECLARE
    result integer;
    task_type settings.modify_type;
    settings_for_modify json;
    users_for_modify_array bigint[];
BEGIN
    SELECT type, settings 
      FROM settings.bulk_modification
      INTO task_type, settings_for_modify 
     WHERE id = 1;

    IF task_type = 'update_for_all' OR task_type = 'update_by_uids' THEN
      users_for_modify_array := (
        SELECT array_agg(uid)
          FROM (SELECT uid 
                  FROM settings.users_for_update
                 WHERE NOT is_modified LIMIT 1000
                 FOR UPDATE SKIP LOCKED
               ) tmp
      );

      PERFORM code.update_settings(uid, settings_for_modify)
        FROM  (SELECT unnest(users_for_modify_array) AS uid) t;

      UPDATE settings.users_for_update
         SET is_modified = TRUE 
        WHERE uid = ANY(users_for_modify_array) AND NOT is_modified;

      GET DIAGNOSTICS result = ROW_COUNT;
      RETURN result;

    ELSIF task_type = 'init' THEN
      users_for_modify_array := (
        SELECT array_agg(uid)
          FROM (SELECT uid 
                  FROM settings.users_for_init
                 WHERE NOT is_modified LIMIT 1000
                 FOR UPDATE SKIP LOCKED
               ) tmp
      );

      PERFORM code.create_settings(uid, settings_for_modify)
        FROM  (SELECT unnest(users_for_modify_array) AS uid) t;

      UPDATE settings.users_for_init
           SET is_modified = TRUE 
          WHERE uid = ANY(users_for_modify_array) AND NOT is_modified;

      GET DIAGNOSTICS result = ROW_COUNT;
      RETURN result;

    ELSE   
      RETURN 0;
    END IF;
END;
$$ LANGUAGE plpgsql;
