CREATE OR REPLACE FUNCTION code.create_task_bulk_modify (
    i_task        text,
    i_modify_type settings.modify_type,
    i_settings    json
) RETURNS boolean AS $$
DECLARE
    running_task_name text; 
    running_task_type settings.modify_type;
BEGIN
    SELECT name, type 
      FROM settings.bulk_modification
      INTO running_task_name, running_task_type 
     WHERE id = 1
       FOR UPDATE;

    IF running_task_name = i_task AND running_task_type = i_modify_type THEN
        RETURN TRUE;
    END IF;

    IF running_task_name  = '' THEN
        IF i_modify_type = 'update_for_all' THEN
            INSERT INTO settings.users_for_update (uid)
            SELECT uid 
              FROM settings.settings
            ON CONFLICT (uid) DO UPDATE
               SET is_modified = FALSE;

        ELSIF i_modify_type = 'update_by_uids' THEN
            DELETE FROM settings.users_for_update;

        ELSIF i_modify_type = 'init' THEN
            INSERT INTO settings.users_for_init (uid)
            SELECT uid 
              FROM (
                SELECT uid 
                  FROM mail.users 
                 WHERE is_here
                   AND NOT is_deleted
                 EXCEPT
                SELECT uid
                  FROM settings.settings
              ) users_on_init
            ON CONFLICT (uid) DO UPDATE
               SET is_modified = FALSE;
        END IF;

        UPDATE settings.bulk_modification
           SET name = i_task,
               create_date = NOW(),
               type = i_modify_type,
               settings = i_settings
         WHERE id = 1;

        RETURN TRUE;
    ELSE
        RETURN FALSE;
    END IF;
END;
$$ LANGUAGE plpgsql;
