CREATE OR REPLACE FUNCTION constants.data_migrations()
    RETURNS TABLE(apply_to_version integer, migration_proc regproc) AS $$
        SELECT apply_to_version, migration_proc::regproc
            FROM (VALUES
                (0, 'util.fix_user'),
                (1, 'util.fix_so_label_types'),
                (2, 'util.merge_tm_into_messages'),
                (3, 'util.remove_unlinked_deleted_messages')
            ) AS v(apply_to_version, migration_proc);
$$ LANGUAGE sql IMMUTABLE;

CREATE OR REPLACE FUNCTION constants.migration_was_applied_to(
    i_migration regproc,
    i_data_version integer
)
    RETURNS boolean AS $$
        SELECT i_data_version >= (apply_to_version + 1)
          FROM constants.data_migrations()
         WHERE migration_proc = i_migration;
$$ LANGUAGE sql IMMUTABLE;
