CREATE OR REPLACE FUNCTION constants.minimal_data_version()
  RETURNS integer AS $$
    SELECT MIN(apply_to_version)
      FROM constants.data_migrations();
$$ LANGUAGE SQL IMMUTABLE;
COMMENT ON FUNCTION constants.minimal_data_version() IS
'data_version in mail.users lesser than that number cannot exist in current DB';

CREATE OR REPLACE FUNCTION constants.newest_data_version()
  RETURNS integer AS $$
    SELECT MAX(apply_to_version) + 1
      FROM constants.data_migrations();
$$ LANGUAGE SQL IMMUTABLE;
COMMENT ON FUNCTION constants.newest_data_version() IS
'Last data_version that is supported by data migration scripts in current DB';